#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <error.h>
#include <string.h>
#include <paths.h>
#include <unistd.h>
#include <sys/un.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ipc.h>
#include <sys/types.h>
#include <stdarg.h>
#include <sys/sysinfo.h>
#include <netinet/in.h>
#include "libmsglog.h"
#define MAX_LOG_BUF 500
#define TP_PATH_LOG "/var/log"

void msglogd(int priority, int logType, char *format, ...)
{
	char buf[MAX_LOG_BUF];
	int  str_len = 0;
	int  addr_len; 
	struct sockaddr_un local_addr;
	int local_sock;
	va_list args;
	
	if ( (logType <= 0) || ( logType > LOGTYPE_OTHER))
	{	
		printf("fail to write log, logType = %d out of range\n", logType);
		return;
	}
	if ( (priority < LOG_EMERG) || ( priority > LOG_DEBUG))
	{	
		printf("fail to write log, logType = %d out of range\n", logType);
		return;
	}
	//printf("Enter msglogd.\n");
	if (priority < LOG_DEBUG)
	{
		memset(buf, '\0', MAX_LOG_BUF);
		sprintf(buf, "<%d><%c%c>", priority,logType + 48, priority + 48);
		str_len = strlen(buf);
		
		va_start(args, format);
		vsprintf(buf + str_len, format, args);
		va_end(args);

		//printf("%s",buf);
		
		local_sock = socket(AF_UNIX, SOCK_DGRAM, 0);
		if (local_sock < 0)
		{
			printf("create local unix socket error.\n");
			return;
		}
		
		local_addr.sun_family = AF_UNIX;
		strncpy(local_addr.sun_path, TP_PATH_LOG, sizeof(local_addr.sun_path));

	//	printf("server path:%s, send message:%s.\n", TP_PATH_LOG, buf);
		
		/*.......system log ...*/
		addr_len = sizeof(local_addr.sun_family) + strlen(local_addr.sun_path);
		sendto(local_sock, buf, strlen(buf), 0, (struct sockaddr*)&local_addr,addr_len);
		close(local_sock);
	}
	
	return;

}


